//**********************************************
typedef int SOCKET;

//**********************************************
//
//      TCP/IP Interface Functions
//
//**********************************************
int     NetInit();
#define WLAN_NETWORKING         0L
#define BLUETOOTH_NETWORKING    1L
#define BT_GPRS_NETWORKING      3L
#define IR_PPP_NETWORKING       4L
#define RS232_PPP_NETWORKING    5L
#define IR_MODE_NETWORKING      6L
int     NetClose(void);
int     Ninit(void);
int     Nterm(void);
int     Portinit(const char *name);
int     Portterm(const char *name);

int     DNS_resolver(const char *remote_host,unsigned char *remote_ip);
int     Nopen(const char *remote_ip, const char *proto, int lp, int rp, int flags);
// flags definition
#define S_NOCON       0x02      // no connection, for UDP
#define S_NOWA        0x04      // non-blocking
#define IPADDR        0x0100    // remote_ip is IP address (binary, 4 bytes) */

int     Nclose(int conno);
int     Nwrite(int conno, const char *buff, int len);
int     Nread(int conno, char *buff, int len);

int     Nportno(void);
int     socket_noblock(int conn);
int     socket_block(int conn);
int     socket_ipaddr(int conn,unsigned char *ipaddr);
int     socket_push(int conn);
int     socket_fin(int conn);
int     socket_testfin(int conn);
int     socket_isopen(int conn);
int     socket_hasdata(int conn);
int     socket_cansend(int conno, unsigned int len);
int     socket_rxtout(int conn, unsigned long val);
int     socket_keepalive(int conn, unsigned long period);
unsigned char MAC_ID(unsigned char *mac_id);    

//
// get connection transmit status
//
int     socket_txstat(int conn);
#define S_PSH         0x01      // push
#define S_FIN_SENT    0x08      // FIN has been sent
#define S_FIN_ACKED   0x10      // my FIN has been ACKED
#define S_PASSIVEOPEN 0x20      // indicate that this is originally a passive open (for simultaneous active open)


//
// get connection receive status
//
int     socket_rxstat(int conn);
#define S_EOF       0x01        // FIN has been received
#define S_UNREA     0x02        // destination unreachable ICMP
#define S_FATAL     0x04        // fatal error
#define S_RST       0x08        // restart message received
#define S_SHUTRECV  0x10        // receive has been shutdown (active, not by receiving FIN)


//
// get connection state
//
char     socket_state(int conn);
#define ESTABLISHED     1
#define SYN_SENT        2
#define SYN_RECEIVED    3
#define LISTEN          4
#define CLOSING         5


//**********************************************
//
//      TCP/IP Error Codes
//
//**********************************************
#define NE_PARAM        -10     /* user parameter error */
#define EHOSTUNREACH    -11     /* host not reachable */
#define ETIMEDOUT       -12     /* timeout */
#define NE_HWERR        -13     /* hardware error */
#define ECONNABORTED    -14     /* protocol error */
#define ENOBUFS         -15     /* no buffer space */
#define EBADF           -16     /* connection block invalid */
#define EFAULT          -17     /* invalid pointer argument */
#define EWOULDBLOCK     -18     /* operation would block */
#define EMSGSIZE        -19     /* message too long */
#define ENOPROTOOPT     -20     /* Protocol not available */
#define ussErrInval     -21     /* this ioctl request not implemented */

#define EDESTADDRREQ    -50     /* Destination address required */
#define EPROTOTYPE      -52         /* Protocol wrong type for socket */
#define EPROTONOSUPPORT -54     /* Protocol not supported */
#define ESOCKTNOSUPPORT -55     /* Socket type not supported */
#define EOPNOTSUPP      -56     /* Operation not supported on socket */
#define EPFNOSUPPORT    -57     /* Protocol family not supported */
#define EAFNOSUPPORT    -58     /* Address family not supported by */

#define EADDRINUSE      -59     /* Address already in use */
#define EADDRNOTAVAIL   -60     /* Can't assign requested address */
#define ENETDOWN        -61     /* Network is down */
#define ENETUNREACH     -62     /* Network is unreachable */
#define ENETRESET       -63     /* Network dropped connection because */

#define ECONNRESET      -65     /* Connection reset by peer */
#define EISCONN         -67     /* Socket is already connected */
#define ENOTCONN        -68     /* Socket is not connected */
#define ESHUTDOWN       -69     /* Can't send after socket shutdown */
#define ECONNREFUSED    -72     /* Connection refused */
#define EHOSTDOWN       -73     /* Host is down */
#define EALREADY        -76     /* operation already in progress */
#define EINPROGRESS     -77     /* operation now in progress */

//********************************************************
//                DNS SERVICE ERROR CODE
//********************************************************
#define UNKNOWNAME                     -30
#define ErrRETCLASS                    -31
#define ErrRETTYPE                     -32
#define RemoteNameTooLong              -33        //parameter input error
#define remote_nameMax                  38


//********************************************************
//                SOCKET Library
//********************************************************
/* protocol family */

#define	PF_UNSPEC	0           /* unspecified protocol family */
#define	PF_INET		2           /* TCP/IP and related */
#define	AF_UNSPEC	0           /* unspecified address family */
#define	AF_INET		2           /* TCP/IP and related */

/* socket types */

#define	SOCK_STREAM	1           /* stream socket */
#define	SOCK_DGRAM	2           /* datagram socket */
#define	SOCK_RAW	3           /* raw-protocol interface */

/* options for getsockopt() and setsockopt() */

#define	SOL_SOCKET	0xffff      /* options for socket level */
#define	IPPROTO_TCP	0x0001      /* options for TCP level */
#define	IPPROTO_IP	0x0002      /* options for IP level */

#define SO_DEBUG        0x0001  /* turn on debugging info recording */
#define	SO_REUSEADDR	0x0004  /* allow local address reuse */
#define	SO_KEEPALIVE	0x0008  /* keep connections alive */
#define	SO_DONTROUTE	0x0010  /* just use interface addresses */
#define	SO_BROADCAST	0x0020  /* permit sending of broadcast msgs */
#define SO_BINDTODEVICE 0x0040  /* Bind a socket to an interface */
#define SO_LINGER       0x0080  /* linger on close if data present */
#define	SO_OOBINLINE	0x0100  /* leave received OOB data in line */
#define SO_SNDBUF       0x1001  /* send buffer size */
#define SO_RCVBUF       0x1002  /* receive buffer size */
#define SO_ERROR        0x1007  /* get error status and clear */
#define SO_TYPE         0x1008  /* get socket type */

#define	TCP_MAXSEG	0x2000      /* maximum segment size */
#define	TCP_NODELAY	0x2001      /* immediate send() */

#define	IP_OPTIONS	0x0001      /* IP header options */

/* options for recv and send */

#define MSG_OOB		0x01        /* send or receive out of band data */
#define MSG_PEEK	0x02        /* take data but leave it */
#define MSG_DONTROUTE	0x04    /* do not route */

/* options for fcntl */

#define O_NDELAY 	0x04        /* non-blocking */
#define FNDELAY O_NDELAY        /* synonym */
#define F_GETFL		3           /* get flags */
#define F_SETFL		4           /* set flags */

/* options for ioctl */

#define SIOCATMARK	7           /* check for out of bound data */
#define FIONBIO		126         /* set/clear non-blocking I/O */
#define FIONREAD	127         /* number of bytes to read */

/* structures */

struct sockaddr {               /* generic socket address */
    unsigned short  sa_family;  /* address family */
    char            sa_data[14];/* up to 14 bytes of direct address */
};

struct in_addr {                /* Internet address */
    unsigned long   s_addr;
};

struct sockaddr_in {            /* Internet socket address */
    short           sin_family; /* should be unsigned but this is BSD */
    unsigned short  sin_port;   /* network order !!! */
    struct in_addr  sin_addr;
    char            sin_zero[8];
};

struct hostent {                /* structure for gethostbyname */
    char           *h_name;     /* official name of host */
    char          **h_aliases;  /* alias list */
    int             h_addrtype; /* host address type */
    int             h_length;   /* length of address */
    char          **h_addr_list;/* list of addresses from name server */
#define	h_addr h_addr_list[0]   /* address, for backward compatiblity */
};

struct servent {                /* structure for getservbyname */
    char           *s_name;     /* official service name */
    char          **s_aliases;  /* alias list */
    int             s_port;     /* port # */
    char           *s_proto;    /* protocol to use */
};

struct linger {                 /* structure for the SO_LINGER option */
    int             l_onoff;    /* zero=off, nonzero = on */
    int             l_linger;   /* linger time, in seconds */
};

/*
** The maximum number of socket descriptors that can have is the same
**   as the number of possible connections (8)
*/
#define FD_SETSIZE 8
#define FD_SET(n, p) ((p)->fds_bits[(n)>>3] |= (1 << ((n) & 7)))
#define FD_CLR(n, p) ((p)->fds_bits[(n)>>3] &= ~(1 << ((n) & 7)))
#define FD_ISSET(n, p) ((p)->fds_bits[(n)>>3] & (1 << ((n) & 7)))
#define FD_ZERO(p) memset((void *)(p), 0, sizeof(*(p)))
typedef struct {
    unsigned char fds_bits [(FD_SETSIZE + 7) / 8];
} fd_set;

struct timeval {                /* Timeout format for select() */
    long            tv_sec;     /* seconds */
    long            tv_usec;    /* microseconds */
};

/* BSD socket error codes */
#define NE_PARAM	    -10         /* user parameter error */
#define EHOSTUNREACH	-11         /* host not reachable */
#define ETIMEDOUT	    -12         /* timeout */
#define ECONNABORTED	-14         /* protocol error */
#define ENOBUFS		    -15         /* no buffer space */
#define EBADF		    -16         /* connection block invalid */
#define EFAULT		    -17         /* invalid pointer argument */
#define	EWOULDBLOCK	    -18         /* operation would block */
#define	EMSGSIZE	    -19         /* message too long */
#define	ENOPROTOOPT	    -20         /* Protocol not available */

#define	EDESTADDRREQ	-50         /* Destination address required */
#define	EPROTOTYPE	    -52         /* Protocol wrong type for socket */
#define	EPROTONOSUPPORT	-54         /* Protocol not supported */
#define	ESOCKTNOSUPPORT	-55         /* Socket type not supported */
#define	EOPNOTSUPP	    -56         /* Operation not supported on socket */
#define	EPFNOSUPPORT	-57         /* Protocol family not supported */
#define	EAFNOSUPPORT	-58         /* Address family not supported by */
 /* protocol family */
#define	EADDRINUSE	    -59         /* Address already in use */
#define	EADDRNOTAVAIL	-60         /* Can't assign requested address */
#define	ENETDOWN	    -61         /* Network is down */
#define	ENETUNREACH	    -62         /* Network is unreachable */
#define	ENETRESET	    -63         /* Network dropped connection because */
 /* of reset */
#define	ECONNRESET	    -65         /* Connection reset by peer */
#define	EISCONN		    -67         /* Socket is already connected */
#define	ENOTCONN	    -68         /* Socket is not connected */
#define	ESHUTDOWN	    -69         /* Can't send after socket shutdown */
#define	ECONNREFUSED	-72         /* Connection refused */
#define	EHOSTDOWN	    -73         /* Host is down */
#define	EALREADY	    -76         /* operation already in progress */
#define	EINPROGRESS	    -77         /* operation now in progress */

/* byte swapping routines */

unsigned short  htons(unsigned short);
#define ntohs(val) htons(val)
unsigned long   htonl(unsigned long);
#define ntohl(val) htonl(val)

/* function prototypes */

int             select(int nfds, fd_set * readfds, fd_set * writefds, fd_set * exceptfds, struct timeval * timeout);
int             accept(SOCKET s, struct sockaddr * name, int *namelen);
int             bind(SOCKET s, struct sockaddr * name, int namelen);
int             connect(SOCKET s, struct sockaddr * name, int namelen);
int             getsockname(SOCKET s, struct sockaddr * name, int *namelen);
int             getpeername(SOCKET s, struct sockaddr * peer, int *addrlen);
int             getsockopt(SOCKET s, int level, int optname, char *optval, int *optlen);
int             setsockopt(SOCKET s, int level, int optname, char *optval, int optlen);
int             listen(SOCKET s, int backlog);
int             recv(SOCKET s, char *buf, int len, int flags);
int             recvfrom(SOCKET s, char *buf, int len, int flags, struct sockaddr * from, int *fromlen);
int             send(SOCKET s, const char *buf, int len, int flags);
int             sendto(SOCKET s, const char *buf, int len, int flags, struct sockaddr * to, int tolen);
int             shutdown(SOCKET s, int how);
SOCKET          socket(int domain, int type, int protocol);
int             closesocket(SOCKET s);
struct hostent *gethostbyname_r(const char *hnp, struct hostent * result,	char *buffer, int buflen, int *h_errnop);
struct hostent *gethostbyname(const char *hnp);
struct hostent *gethostbyaddr_r(char *addr, int len, int type, struct hostent * result, char *buffer, int buflen, int *h_errnop);
struct hostent *gethostbyaddr(char *addr, int len, int type);
int             fcntlsocket(int fildes, int cmd, int arg);
int             ioctlsocket(int fildes, int request,...);
unsigned long   inet_addr(char *dotted);
char           *inet_ntoa(struct in_addr addr);
